/**
  ******************************************************************************
  * @file    kpm32xx_ddl_sci_common.h
  * @author  Kiwi Software Team
  * @brief   Header file of SCI Common DDL module.
  * @note
  *          V1.0.0, 2024/12/20.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  ******************************************************************************
  */


#ifndef __KPM32xx_DDL_SCI_COMMON_H
#define __KPM32xx_DDL_SCI_COMMON_H


#ifdef __cplusplus
extern "C" {
#endif

#include "kpm32xx_ddl_def.h"

#define __DDL_SCI_PRESCALER_CONFIG(__INSTANCE__, __FISRT_PRESCALER__, __SECOND_PRESCALER__)  do { \
																									WRITE_REG((__INSTANCE__)->CLK, (__FISRT_PRESCALER__ << (SCI_CLK_PRESCALER_Pos))); \
																									if (__SECOND_PRESCALER__ <= 31) { \
																										WRITE_REG((__INSTANCE__)->BDR, (__SECOND_PRESCALER__ << (SCI_BDR_DIV1_Pos))); \
																									} else { \
																										WRITE_REG((__INSTANCE__)->BDR, (__SECOND_PRESCALER__ << (SCI_BDR_DIV2_Pos))); \
																									} \
																								}while(0U);

#define __DDL_SCII2C_PRESCALER_CONFIG(__INSTANCE__, __FISRT_PRESCALER__, __SECOND_PRESCALER__)  do { \
																									   WRITE_REG((__INSTANCE__)->CLK, (__FISRT_PRESCALER__ << (SCI_CLK_PRESCALER_Pos))); \
																									   WRITE_REG((__INSTANCE__)->BDR, (__SECOND_PRESCALER__ << (SCI_BDR_DIV2_Pos))); \
																								}while(0U);

#define __DDL_SU_PRESCALER_GET(__INSTANCE__, __CHN_INDEX__)                    (uint32_t)((READ_REG((__INSTANCE__)->CLK) & (0xFUL << (__CHN_INDEX__ * 4))) >> (__CHN_INDEX__ * 4))

#define SCI_AS_UART_MODE    0x01      /* SCI interface used as UART */
#define SCI_AS_SPI_MODE     0x02      /* SCI interface used as SPI */
#define SCI_AS_I2C_MODE     0x03      /* SCI interface used as I2C */
#define SCI_AS_SYNC_MODE    0x04      /* SCI interface used as Sync */
#define SCI_AS_SMCD_MODE    0x05      /* SCI interface used as Smart Card */

/* SCI mode Configuration */
#define __DDL_SCI_CONFIGURE_MODE(__INSTANCE__, __MODE__)                       MODIFY_REG((__INSTANCE__)->MC, SCI_MC_MODSEL_Msk,  __MODE__)

/* MSB or LSB Configuration */
#define __DDL_SCI_MLSB_FIRST(__INSTANCE__, __MLSB__)                           MODIFY_REG((__INSTANCE__)->MC, SCI_MC_DATDIR_Msk, __MLSB__)

/* Data Inversion */
#define __DDL_SCI_DATA_INVERSION(__INSTANCE__)                                 SET_BIT((__INSTANCE__)->MC, SCI_MC_DATINV)

/* Data filter */
#define __DDL_SCI_INF_CLKFILTER_ENABLE(__INSTANCE__)                           SET_BIT((__INSTANCE__)->MC, SCI_MC_CLKFILT)

/* Clock filter */
#define __DDL_SCI_INF_DATFILTER_ENABLE(__INSTANCE__)                           SET_BIT((__INSTANCE__)->MC, SCI_MC_DATFILT)


/**
  * @brief  get SCI instance IRQn.
  * @param  sciInstance  SCI instance.
  *
  * @retval SCI instance IRQn.
  */
IRQn_Type DDL_Get_SCIModule_IRQn(SCI_Type *SCIx);


/**
  * @brief  make SCI active.
  * @param  SCIx  SCI instance.
  *
  */
void DDL_SCI_Instance_Active(SCI_Type *SCIx);

#ifdef __cplusplus
}
#endif

#endif /* __KPM32xx_DDL_SCI_COMMON_H */
