/**
  ******************************************************************************
  * @file    kpm32xx_ddl_ioport.h
  * @author  Kiwi Software Team
  * @brief   Header file of  IOPORT DDL module.
  * @note
  *          V1.0.0, 2024/12/20.
  *
  * Copyright (c) 2024, Kiwi Instruments Co., Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */


#ifndef __KPM32xx_DDL_IOPORT_H
#define __KPM32xx_DDL_IOPORT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "kpm32xx_ddl_def.h"


/* IO Port edge detection */
#define IOPORT_EDGEDECT_NONE          0x00U
#define IOPORT_EDGEDECT_RISING        0x01U
#define IOPORT_EDGEDECT_FALLING       0x02U
#define IOPORT_EDGEDECT_RISEORFALL    0x03U

/* IO Port Pins */
#define IOPORT_PIN_0                  0x00U
#define IOPORT_PIN_1                  0x01U
#define IOPORT_PIN_2                  0x02U
#define IOPORT_PIN_3                  0x03U
#define IOPORT_PIN_4                  0x04U
#define IOPORT_PIN_5                  0x05U
#define IOPORT_PIN_6                  0x06U
#define IOPORT_PIN_7                  0x07U
#define IOPORT_PIN_8                  0x08U
#define IOPORT_PIN_9                  0x09U
#define IOPORT_PIN_10                 0x0AU
#define IOPORT_PIN_11                 0x0BU
#define IOPORT_PIN_12                 0x0CU
#define IOPORT_PIN_13                 0x0DU
#define IOPORT_PIN_14                 0x0EU
#define IOPORT_PIN_15                 0x0FU

/* IO Selectn */
#define IOPORT_BITA          0x00U
#define IOPORT_BITB          0x01U
#define IOPORT_BITC          0x02U
#define IOPORT_BITD          0x03U
#define IOPORT_BITE          0x04U


typedef struct
{
	uint32_t ioPortPin;
	uint32_t edgeDect;     /* Edge Detection Sources */
	uint32_t ioSelect;
	uint32_t prePriority;  /* Preempt Interrupt priority for IO Port */
	uint32_t subPriority;  /* Sub Interrupt priority for IO Port */
} IOPORT_Init_T;


/**
  * @brief  Configure IO Port parameters.
  * @param  ioPortx     IO PORT instance.
  * @param  ioPortInit  pointer to a IOPORT_Init_T structure.
  *
  * @retval none
  */
void DDL_IOPort_Config(IOPORT_Type  *ioPortx, IOPORT_Init_T *ioPortInit);


/**
  * @brief  Change IO edge detection.
  * @param  ioPortx   IO PORT instance.
  * @param  ioPortPin IO Port Pin.
  * @param  edgeDect  Edge Detection Sources.
  *
  * @retval none
  */
void DDL_IOPort_ChangeEdgeDetection(IOPORT_Type *ioPortx, uint32_t ioPortPin, uint32_t edgeDect);


/**
  * @brief  Clear IO Port interrupt status.
  * @param  ioPortx     IO PORT instance.
  * @param  ioPortPin   the given IO Port Pin (IOPORT_PIN_0 ~ IOPORT_PIN_11).
  *
  * @retval none
  */
void DDL_IOPort_PinInt_Clear(IOPORT_Type *ioPortx, uint32_t ioPortPin);


#ifdef __cplusplus
}
#endif

#endif /** __KPM32xx_DDL_IOPORT_H */
