/**
  ******************************************************************************
  * @file    kpm32xx.h
  * @author  Kiwi Software Team
  * @brief   Header file of common macro definition.
  * @note
  *          V1.0.0, 2024/12/20.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *  1. Redistributions of source code must retain the above copyright notice,
  *	 this list of conditions and the following disclaimer.
  *
  *  2. Redistributions in binary form must reproduce the above copyright notice,
  *	 this list of conditions and the following disclaimer in the documentation
  *	 and/or other materials provided with the distribution.
  *
  *  3. Neither the name of the copyright holder nor the names of its contributors
  *	 may be used to endorse or promote products derived from this software without
  *	 specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  ******************************************************************************
  */


#ifndef __KPM32xx_H
#define __KPM32xx_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* Chipset remapping */
#if defined(KPM32R24TPAKEG) || defined(KPM32R24TTAKEG) || defined(KPM32R24TTCKEG)
	#include "KPM32R24Txx.h"
#elif defined(KPM32R28TPCKEG) || defined(KPM32R28TTCKEG)
	#include "KPM32R28Txx.h"
#elif defined(KPM32R14TTCKEG) || defined(KPM32R14TTAKEG) || defined(KPM32R14TPCKEG) \
	|| defined(KPM32R14TPAKEG) || defined(KPM32G14CTAKEG) || defined(KPM32G14CTCKEG) \
	|| defined(KPM32G14BTAKEG) || defined(KPM32G14BTCKEG) || defined(KPM32G14CPAKEG)
	#include "KPM32x14xx.h"	
#else
	#error "Please select the target KPM32xx device used in your application (in KPM32xx.h file)"
#endif



typedef enum
{
	RESET = 0,
	SET = !RESET
} FlagStatus_T;

typedef enum
{
	DISABLE = 0,
	ENABLE = !DISABLE
} FunctionalState_T;

typedef enum
{
	SUCCESS = 0,
	ERROR = !SUCCESS
} ErrorStatus_T;


#define SET_BIT(REG, BIT)     ((REG) |= (BIT))

#define CLEAR_BIT(REG, BIT)   ((REG) &= ~(BIT))

#define READ_BIT(REG, BIT)    ((REG) & (BIT))

#define TOGGLE_BIT(Reg, Bit)  (Reg)^=(Bit)

#define CLEAR_REG(REG)        ((REG) = (0x0))

#define WRITE_REG(REG, VAL)   ((REG) = (VAL))

#define READ_REG(REG)         ((REG))

#define MODIFY_REG(REG, CLEARMASK, SETMASK)  WRITE_REG((REG), (((READ_REG(REG)) & (~(CLEARMASK))) | (SETMASK)))

#define GET_BITS(Reg, Bits)  ((Reg)&(Bits))

#define SET_BITS(Reg, Bits)  (Reg)|=(Bits)

#define CLEAR_BITS(Reg, Bits) (Reg)&=~(Bits)

#define SET_BITMASK(Reg, Bitmask, Setmask)    (Reg)=(((Reg) & (~(Bitmask))) | (Setmask))

/* convert bit-band address and bit number to alias address */
#define BITBAND(Addr, Bitnum)   ((Addr & 0xF0000000) + 0x2000000 + ((Addr & 0xFFFFF) << 5) + (Bitnum << 2))
#define MEM_ADDR(Addr)          (*((volatile unsigned long *)(Addr)))
/* bit-band operation macro */
#define BIT_ADDR(Addr, Bitnum)   MEM_ADDR(BITBAND(Addr,Bitnum))

#define MIN(A,B)  ((A) <=(B) ? (A) : (B))

#define RAMFUNC __attribute__ ((section (".ramfunc")))

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __KPM32xx_H */

