/**
  ******************************************************************************
  * @file    spi_norflash.h
  * @author  Kiwi Software Team
  * @brief   Header file of spi norflash.
  * @note
  *    	     V1.0.0, 2025/1/7.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  ******************************************************************************
  */

#ifndef __SPI_NORFLASH_H
#define __SPI_NORFLASH_H

#ifdef __cplusplus
extern "C" {
#endif


#include "kpm32xx_ddl.h"
#include <stdio.h>


#define __MAX_PP_DATE_LENGTH__               32
#define __NF_SECTOR_SIZE_INBYTE__            4096
#define __NF_ACCESS_WAITFOREVER__            0xFFFFFFFE

DDL_Status_T DDL_SPI_NorFlash_Init(void);
DDL_Status_T DDL_SPI_NorFlash_RDID(uint8_t *idbuf, uint8_t idlen, uint32_t timeout);
DDL_Status_T DDL_SPI_NorFlash_RMES(uint8_t *mesbuf, uint8_t meslen, uint32_t timeout);
DDL_Status_T DDL_SPI_NorFlash_RDSR(uint8_t *srbuf, uint8_t srlen, uint32_t timeout);
DDL_Status_T DDL_SPI_NorFlash_WREN(void);
DDL_Status_T DDL_SPI_NorFlash_WRDI(void);
DDL_Status_T DDL_SPI_NorFlash_RDDT(uint32_t nfaddr, uint8_t *rdbuf, uint8_t rdlen, uint32_t timeout);
DDL_Status_T DDL_SPI_NorFlash_SE(uint32_t nfaddr, uint32_t timeout);
DDL_Status_T DDL_SPI_NorFlash_PP(uint32_t nfaddr, uint8_t *wrbuf, uint8_t wrlen, uint32_t timeout);

/********************SPI Nor Flash Status Register*************************/
#define NORFLASH_STR_WIP_Pos                 (0U)
#define NORFLASH_STR_WIP_Msk                 (0x1UL << NORFLASH_STR_WIP_Pos)
#define NORFLASH_STR_WIP                     NORFLASH_STR_WIP_Msk
#define NORFLASH_STR_WEL_Pos                 (1U)
#define NORFLASH_STR_WEL_Msk                 (0x1UL << NORFLASH_STR_WEL_Pos)
#define NORFLASH_STR_WEL                     NORFLASH_STR_WEL_Msk


#ifdef __cplusplus
}
#endif

#endif /* __SPI_NORFLASH_H */
