/**
  *****************************************************************************************************
  * @file    iic_user_drv.h
  * @author  Kiwi Software Team
  * @brief   Header file of iic_user_drv.c module.
  * @note
  *          V1.0.0, 2022/08/03.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */



#ifndef __IIC_USER_DRV_H
#define __IIC_USER_DRV_H

#ifdef __cplusplus
extern "C" {
#endif

#include "kpm32xx_demoboard_ddl.h"
#include <stdio.h>


typedef enum
{
	IIC_TX        = 0x02U,
	IIC_RX        = 0x01U,
} IicTxRx_T;


/**
  * @brief  I2C as master transmits an amount of data with interrupt.
  * @param  I2Cx     Pointer to IIC instance.
  *         slvAddr  slave address.
  *         pData    pointer to data buffer.
  *         size     the amount of data to be sent.
  *
  * @retval DDL status
  */
DDL_Status_T DDL_I2C_Master_Transmit_IT(I2C_Type *I2Cx, uint16_t slvAddr, uint8_t *pData, uint16_t size);


/**
  * @brief  I2C as master receives an amount of data with interrupt.
  * @param  I2Cx     Pointer to IIC instance.
  *         slvAddr  slave address.
  *         pData    pointer to data buffer.
  *         size     the amount of data to receive.
  *
  * @retval DDL status
  */
DDL_Status_T DDL_SCII2C_Master_Receive_IT(I2C_Type *I2Cx, uint16_t slvAddr, uint8_t *pData, uint16_t size);


#ifdef __cplusplus
}
#endif

#endif /* __IIC_USER_DRV_H */
