#include "simulator_uart_driver.h"
#include "simulator_uart_app.h"

#define TIMSx    TIMS2
#define TIMSx_IRQn  TIMS2_IRQn
GPIO_Evt_T gpio_ebus_init;
EBUS_Init_T eBusStruct[2];

uint32_t srcBuffer[12] = 
{
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111,
	0x11111111
};
uint32_t dstBuffer[12];


extern SIMU_UART_CONFIG_T uart_config;
DMA_ChannelConfig_T pDMAStruct;
uint32_t transLen = 0;
void dma_init(void)
{ 
	__DDL_RCC_DMA_ACTIVE();
	__DDL_RCC_DMA_CLK_RELEASE();


	DDL_DMA_ChannelStructInit(&pDMAStruct);	
	DDL_DMA_Init(DMA);
    NVIC_EnableIRQ(DMA_IRQn);
    NVIC_SetPriority(DMA_IRQn, __PREEMPT_INTRERRUPT_PRIORITY_0__);
	DDL_DMA_IntEnable(DMA, DMA_CHANNEL_0);
	DDL_DMA_IntEnable(DMA, DMA_CHANNEL_1);
}



void dma_trans_tx(uint8_t txDataLen)
{
	/* uart tx */
	pDMAStruct.ebusEnable = SET;
	pDMAStruct.ebusEvent  = EBUS_CHN_0;
	pDMAStruct.transmitType = DMA_TRANSMIT_NORMAL;
	pDMAStruct.increment = DMA_SRC_INC_DST_KEEP;
    /* Configure the source, destination address and the data length */
    pDMAStruct.srcAddress = (uint32_t)srcBuffer;/*0x40010000,SRAM_BASE+0x20,FLASH_BASE*/
    pDMAStruct.dstAddress = (uint32_t)0x50000018;//GPIOA->DOSR;/*0x40030004*/
    pDMAStruct.dataLength = txDataLen;
	DDL_DMA_SetChannelConfig(DMA, DMA_CHANNEL_0, &pDMAStruct);
	DDL_DMA_ChannelStart(DMA, DMA_CHANNEL_0, DMA_DEVICE_3, &pDMAStruct);
	
}
void dma_trans_rx(uint8_t rxDataLen)
{
	/* uart rx */
	memset(dstBuffer, 0, sizeof(dstBuffer));
	pDMAStruct.ebusEnable = SET;
	pDMAStruct.ebusEvent  = EBUS_CHN_1;
	pDMAStruct.transmitType = DMA_TRANSMIT_NORMAL;
	pDMAStruct.increment = DMA_SRC_KEEP_DST_INC;
    /* Configure the source, destination address and the data length */
    pDMAStruct.srcAddress = (uint32_t)0x50000010;/*GPIOA->DT*/
    pDMAStruct.dstAddress = (uint32_t)dstBuffer;//GPIOA->DOSR;/*0x40030004*/
    pDMAStruct.dataLength = rxDataLen;
	DDL_DMA_SetChannelConfig(DMA, DMA_CHANNEL_1, &pDMAStruct);
	DDL_DMA_ChannelStart(DMA, DMA_CHANNEL_1, DMA_DEVICE_3, &pDMAStruct);
}


void BTM00_16bit_Init(void)
{
	
	BTM_BaseInit_T btm00Struct;
	/* To make BTM active */
	DDL_BTM_Instance_Active();
	
	DDL_BTM_StructInit(&btm00Struct);
	btm00Struct.eventOuput = EVT_ENABLE;
	btm00Struct.clkSource = BTM_MCLK;
	btm00Struct.loadValue  = uart_config.txBaud;
	DDL_BTM_Init(BTIM00, &btm00Struct);
	DDL_BTM_IntEnable(BTIM00);
	
	/* Start Basetimer(BTM) */
	DDL_BTM_Start(BTIM00);
}

void ebus_init(void)
{
	DDL_EBUS_Instance_Active();

    DDL_EBUS_StructInit(&eBusStruct[0]);
	eBusStruct[0].syncMode     = EBUS_CHN_SYNC_MODE;
	eBusStruct[0].channel      = EBUS_CHN_0;
	eBusStruct[0].mstrSrc      = EBUS_CHN_MSTR_BTM1;
	eBusStruct[0].out2Pad      = EBUS_CHN_OUT2PAD_ENABLE;
	eBusStruct[0].detSrc       = EBUS_CHN_DETSRC_RISING;
	DDL_EBUS_Init(EBUS, &eBusStruct[0]);
	
	
	DDL_EBUS_StructInit(&eBusStruct[1]);
	eBusStruct[1].syncMode     = EBUS_CHN_SYNC_MODE;
	eBusStruct[1].channel      = EBUS_CHN_1;
	eBusStruct[1].mstrSrc      = EBUS_CHN_MSTR_TIMS2_TRGO;
	eBusStruct[1].out2Pad      = EBUS_CHN_OUT2PAD_ENABLE;
	eBusStruct[1].detSrc       = EBUS_CHN_DETSRC_RISING;
	DDL_EBUS_Init(EBUS, &eBusStruct[1]);
	
	
	memset(&gpio_ebus_init,0,sizeof(GPIO_Evt_T));
	gpio_ebus_init.pin = GPIO_PIN_14;
	gpio_ebus_init.evtChn = EBUS_CHN_1;
	gpio_ebus_init.evtAck = EVTACK_OP_TOGGLE;
	DDL_GPIO_EBus_Start(GPIOC,&gpio_ebus_init);
}

void ioport_init(void)
{
	IOPORT_Init_T ioPortInit;

	 __DDL_RCC_EBUS_ACTIVE();
    __DDL_RCC_EBUS_CLK_RELEASE();
	/* PIN0 */
	ioPortInit.ioPortPin   = IOPORT_PIN_1;
	ioPortInit.edgeDect    = IOPORT_EDGEDECT_FALLING;
	ioPortInit.ioSelect    = IOPORT_BITA;//PA1
    
	DDL_IOPort_Config(IOPORT, &ioPortInit);
    NVIC_EnableIRQ(INTP1_IRQn);
	NVIC_SetPriority(INTP1_IRQn, __PREEMPT_INTRERRUPT_PRIORITY_0__);
	
}

void tims_pwm_init(void)
{
	TIMS_BaseInit_T tmrStruct;
	
	DDL_TIMS_Instance_Active(TIMSx);
	DDL_TIMS_PWM_StructInit(&tmrStruct);
	tmrStruct.countermode = TIMS_COUNTERMODE_COUNTER_UP;
	tmrStruct.period = uart_config.rxBaud;//24000;//20799;
	tmrStruct.repetitionCounter = 0;
	DDL_TIMS_PWM_Init(TIMSx,&tmrStruct);
	
	/* ch1 init config */
	DDL_TIMS_Ch1_HighResistsnceState_Config(TIMSx, 0, 0);
	DDL_TIMS_Ch1_BrkIdelState_Config(TIMSx, 0, 0);
	DDL_TIMS_Ch1_Duty_Config(TIMSx, 1, (tmrStruct.period/2));
	DDL_TIMS_Ch1_PWM_Mode_Config(TIMSx,TIMS_OCMODE_PWM0_CH1);
	
	/* channel enable */
	DDL_TIMS_PWM_Enable(TIMSx,TIMS_CHANNEL1);
	DDL_TIMS_AsMaster_Trgo(TIMSx,3); /* CC1F */
	
	NVIC_SetPriority(TIMSx_IRQn, 0);
	NVIC_EnableIRQ(TIMSx_IRQn);
	DDL_TIMS_IntEnable(TIMSx,TIMS_IER_CC1IE);
	MODIFY_REG(TIMSx->BDTR, TIMS_BDTR_MOE , 1 << TIMS_BDTR_MOE_Pos);
}




