/**
  ******************************************************************************
  * @file    kpm32xx_ddl_lvd.h
  * @author  Kiwi Software Team
  * @brief   Header file of Low Voltage Detector DDL module.
  * @note
  *    	     V1.0.0, 2021/12/13.
  *
  Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  ******************************************************************************
  */


#ifndef __KPM32xx_DDL_LVD_H
#define __KPM32xx_DDL_LVD_H

#ifdef __cplusplus
  extern "C" {
#endif


#include "kpm32xx_ddl_def.h"

/* LVD device index definition */
typedef enum
{
	LVD_INDEX_1           = 0x1U,        /* LVD 1 */
	LVD_INDEX_2           = 0x2U,        /* LVD 2 */
} LVD_Index_T;

/* LVD voltage detect level definition */
typedef enum
{
	LVD_DETECT_LEVEL_0    = 0x00U,       /* 1.80+0.05V/-0.05V */
	LVD_DETECT_LEVEL_1    = 0x01U,       /* 1.90+0.05V/-0.05V */
	LVD_DETECT_LEVEL_2    = 0x02U,       /* 2.00+0.05V/-0.05V */
	LVD_DETECT_LEVEL_3    = 0x03U,       /* 2.20+0.05V/-0.05V */
	LVD_DETECT_LEVEL_4    = 0x04U,       /* 2.40+0.05V/-0.05V */
	LVD_DETECT_LEVEL_5    = 0x05U,       /* 2.60+0.05V/-0.05V */
	LVD_DETECT_LEVEL_6    = 0x06U,       /* 2.80+0.05V/-0.05V */
	LVD_DETECT_LEVEL_7    = 0x07U,       /* 3.00+0.05V/-0.05V */
	LVD_DETECT_LEVEL_8    = 0x08U,       /* 3.20+0.05V/-0.05V */
	LVD_DETECT_LEVEL_9    = 0x09U,       /* 3.40+0.05V/-0.05V */
	LVD_DETECT_LEVEL_10   = 0x0AU,       /* 3.60+0.05V/-0.05V */
	LVD_DETECT_LEVEL_11   = 0x0BU,       /* 3.80+0.05V/-0.05V */
	LVD_DETECT_LEVEL_12   = 0x0CU,       /* 4.00+0.05V/-0.05V */
	LVD_DETECT_LEVEL_13   = 0x0DU,       /* 4.20+0.05V/-0.05V */
	LVD_DETECT_LEVEL_14   = 0x0EU,       /* 4.40+0.05V/-0.05V */
	LVD_DETECT_LEVEL_15   = 0x0FU,       /* 4.50+0.05V/-0.05V */
} LVD_DetectLevel_T;

/* LVD2 filter clock prescaler */
typedef enum
{
	LVD_CLK_PSC_0         = 0x00U,       /* no prescaler  */
	LVD_CLK_PSC_2         = 0x01U,       /* 2 prescaler   */
	LVD_CLK_PSC_4         = 0x02U,       /* 4 prescaler   */
	LVD_CLK_PSC_8         = 0x03U,       /* 8 prescaler   */
	LVD_CLK_PSC_16        = 0x04U,       /* 16 prescaler  */
	LVD_CLK_PSC_32        = 0x05U,       /* 32 prescaler  */
	LVD_CLK_PSC_64        = 0x06U,       /* 64 prescaler  */
	LVD_CLK_PSC_128       = 0x07U,       /* 128 prescaler */
} LVD_FilterClkPsc_T;


/* Configure LVD init parameters */
typedef struct
{
	LVD_DetectLevel_T   detectLevel;       /* LVD voltage detect level select */
	LVD_FilterClkPsc_T  filterClkPsc;      /* For LVD2 to set filter clock prescaler */
	uint32_t            filterThreshold;   /* For LVD2 to set filter threshold */
} LVD_Init_T;


/**
  * @brief  Initialize the Low Voltage dector accoding to the specify parameters.
  * @param  index LVD index.
  * @param  init  Pointer to a LVD_Init_T structure that contains
  *               the configuration information for the specified LVD.
  * @retval DDL status
  */
DDL_Status_T DDL_LVD_Init(LVD_Index_T index, LVD_Init_T *init);



#ifdef __cplusplus
}
#endif


#endif /* __KPM32xx_DDL_LVD_H */

