/**
  *****************************************************************************************************
  * @file    kpm32xx_ddl_def.h
  * @author  Kiwi Software Team
  * @brief   This file contains DDL common defines, enumeration, macros and
  *          structures definitions.
  * @note
  *          V1.0.0, 2025/1/7.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */


#ifndef __KPM32xx_DDL_DEF
#define __KPM32xx_DDL_DEF

#ifdef __cplusplus
extern "C" {
#endif


#include "kpm32xx.h"
#include <stddef.h>
#include <stdint.h>


/**
  * Status definitions for MCU peripheral Device-Driver-Layer APIs
  */
typedef enum
{
	DDL_OK        = 0x00U,
	DDL_ERROR     = 0x01U,
	DDL_BUSY      = 0x02U,
	DDL_TIMEOUT   = 0x03U,
	DDL_INVPARAM  = 0x04U
} DDL_Status_T;


/* Fix compiling warnings for GNU GCC/G++ toolchain */
#define UNUSED(X)          (void)X
/* Maximum timeout definition for Device-Driver-Layer */
#define DDL_MAX_DELAY      0xFFFFFFFFU


#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
	#ifndef __weak
		#define __weak  __attribute__((weak))
	#endif
	#ifndef __packed
		#define __packed  __attribute__((packed))
	#endif
#elif  defined ( __GNUC__ ) && !defined (__CC_ARM) /* GNU Compiler */
	#ifndef __weak
		#define __weak   __attribute__((weak))
	#endif
	#ifndef __packed
		#define __packed __attribute__((__packed__))
	#endif
#endif


#ifdef __cplusplus
}
#endif

#endif /* __KPM32xx_DDL_DEF */

