/**
  *****************************************************************************************************
  * @file    system_kpm32xx.c
  * @author  Kiwi Software Team
  * @brief   CMSIS Cortex-M4 Device Peripheral Access Layer System Source File.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */


#include "kpm32xx.h"



/* Macro for relocating Vector Table to SRAM */
/* #define VECT_TAB_RELOC2SRAM */

/* Vector Table base offset field. This value must be a multiple of 0x100 as reference to ARM Specification */
#define VECT_TAB_OFFSET  0x0U

/* CPU works at the frequence of 8MHz(HIRC) after reset.
 * And Application Software Programmer should not modify this value.
 */
uint32_t systemCoreClock = 8000000UL;

/*
 * SystemInit routine is implemented for ARM Vector Table Relocation.
 */
void SystemInit(void)
{
	/* FPU settings */
  #if (__FPU_PRESENT == 1) && (__FPU_USED == 1)
    SCB->CPACR |= ((3UL << 10*2) | (3UL << 11*2));  /* set CP10 and CP11 Full Access */
  #endif

#ifdef VECT_TAB_RELOC2SRAM
    /* Vector Table was relocated in Internal SRAM */
    SCB->VTOR = SRAM_BASE | VECT_TAB_OFFSET;
#else
    /* Vector Table was relocated in in Internal FLASH */
    SCB->VTOR = FLASH_BASE | VECT_TAB_OFFSET;
#endif
}

void BootInit(void)
{
    /* Vector Table was relocated in bootrom */
    SCB->VTOR = FLASH_BOOTROM_BASE | VECT_TAB_OFFSET;
}

