/**
  *****************************************************************************************************
  * @file    kpm32xx_it.c
  * @author  Kiwi Software Team
  * @brief   This file provides routines for all CPU exceptions handler and
  *          external peripherals interrupt service.
  *
  * Copyright (c) 2021, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */

#include "main.h"


/**
  * @brief This function handles Non-Maskable interrupt.
  */
void NMI_Handler(void)
{

}


/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
	while (1)
	{

	}
}


/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{

}


/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{

}


/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
    DDL_IncTick();
}


#if defined(DDL_ADC_MODULE_ENABLED)
extern volatile uint32_t ebusSoc0Flag;
extern volatile uint32_t ebusSoc1Flag;

/**
  * @brief This function handles ADC interrupt.
  */
void ADC0_IRQHandler(void)
{
	if (ADC0->STATUS & ADC_STATUS_SOC0INT)
	{
		ebusSoc0Flag = 1;
		WRITE_REG(ADC0->CLEAR, ADC_CLEAR_SOC0INT);
	}

	if (ADC0->STATUS & ADC_STATUS_SOC1INT)
	{
		ebusSoc1Flag = 1;
		WRITE_REG(ADC0->CLEAR, ADC_CLEAR_SOC1INT);
	}

	WRITE_REG(ADC0->CLEAR, ADC_CLEAR_SOCOVFINT);
}
#endif


