/**
  *****************************************************************************************************
  * @file    acm32g4xx_it.c
  * @author  AdvanChip Software Team
  * @brief   This file provides routines for all CPU exceptions handler and
  *          external peripherals interrupt service.
  *
  * Copyright (c) 2021, Advanchip Semiconductor Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */


#include "main.h"


/**
  * @brief This function handles NMI interrupt.
  */
void NMI_Handler(void)
{

}


/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
    while (1)
    {

    }
}


/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{

}


/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{

}


/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
    DDL_IncTick();
}


#ifdef DDL_DMA_MODULE_ENABLED
uint8_t dma_tx_success_flag =0;
uint8_t dma_rx_success_flag =0;

void DMA_IRQHandler(void)
{
	if (DMA->INT_FLAG & (0x1UL << DMA_CHANNEL_0))
	{
		__DDL_DMA_CLEAR_IT_FLAG(DMA, (0x1UL << DMA_CHANNEL_0));
		__DDL_DMA_CLEAR_ERR_STATUS(DMA);
		CLEAR_BIT(BTIM00->CTRL, 0x1);
		dma_tx_success_flag = 1;	
       
	}
	
	if (DMA->INT_FLAG & (0x1UL << DMA_CHANNEL_1))
	{
		__DDL_DMA_CLEAR_IT_FLAG(DMA, (0x1UL << DMA_CHANNEL_1));
		__DDL_DMA_CLEAR_ERR_STATUS(DMA);   
		
		
		CLEAR_BIT(TIMS2->CR,  TIMS_CR_CEN);
		DDL_IOPort_ChangeEdgeDetection(IOPORT, IOPORT_PIN_1, IOPORT_EDGEDECT_FALLING);
		dma_rx_success_flag = 1;
	}
}

#endif
/**
  * @brief In this actual application, only IOPORT interrupt was used.
  *        And, we leave all used interrupts as default, which are implemented
  *        in startup_acm32xxxx.s.
  */
#if defined(DDL_IOPORT_MODULE_ENABLED)

void IOPort_INTP1_IRQHandler(void)
{
	DDL_IOPort_PinInt_Clear(IOPORT, IOPORT_PIN_1);
	DDL_IOPort_ChangeEdgeDetection(IOPORT, IOPORT_PIN_1, IOPORT_EDGEDECT_NONE);

	TIMS2->SETKR = 0xD79B3EFD;
	TIMS2->CNT = 0;
	TIMS2->SETKR = 1111111;
	MODIFY_REG(TIMS2->CR,  TIMS_CR_CEN ,  1 << TIMS_CR_CEN_Pos);
	
	
}
#endif
/**
  * @brief This function handles TIMS2.
  */
void TIMS2_IRQHandler(void)
{
	if ((TIMS2->SR & TIMS_SR_CC1IF) == TIMS_SR_CC1IF)
	{
		WRITE_REG(TIMS2->SR,TIMS_SR_CC1IF);
	}
	else
	{
		WRITE_REG(TIMS2->SR,TIMS2->SR);
	}
}



