/**
  *****************************************************************************************************
  * @file    main.c
  * @author  Kiwi Software Team
  * @brief   This example code demonstrates how tmu works.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */

#include "main.h"
#include "kpm32xx_demoboard_ddl.h"


const float fltAngle[]  = {6.207611, 0.175229, 1.755815, 4.393457, 6.164314, -2.875489, 2.344557, -0.875685, -1.272221, 1.442685, 5.666924, 1.287326, 6.100163, 1.231151, 6.037906, 6.052087, 1.015383, 2.599239, -5.42202, 4.255305, 0.748415, 2.78698, 6.207668, -4.187464, -5.570007, -4.786296, -4.404121, -5.762023, -4.741293, 5.833985, 5.341066, 4.438307};

const float fltX[]      = {-16001.466899, -5056.331397, 9913.988447, -59954.787894, 34880.291282, -64417.324018, 2228.819771, -42876.877309, 37141.056794, -43978.287744, 51218.488828, -30835.588661, -48554.279256, 55196.78584, -22507.915405, 30802.159113, 16790.079796, -63360.505589, 16201.60293, -21939.452601, 12616.209866, -9255.887308, 2846.671885, -6316.131952, -55924.060284, 32199.41225, -41160.29615, 16021.462227, 48727.54845, -51969.096189, 30711.093485, 44943.89421, -37683.405677, 7824.067764, -22110.894208, -43260.555485, -55917.948663, 17648.639856, -61600.805491, -61836.69508, 60300.863319, 762.039939, -11066.270227, 26878.104548, 27027.37093, -25663.287089, -13578.251552, -62914.906216, 2549.476267, 64069.659931, 58379.128736, -3668.043782, -26521.760115, 48291.963489, 44429.778509, 49316.138861, -2753.905066, -31771.925374, -10108.874298, -11519.637991, 23934.775455, -5750.366944, -21394.898828, 53860.43265, 39790.983352, -23500.537074, 48071.844853, 25753.095153, -35543.54517, -37431.344904, -16005.477536, 48167.338144, -22372.091212, 5899.298572, 41159.649272, 41690.490708, 10833.130713, 30319.952088, -33148.917728, 5142.403739, 8003.050489, 9256.776844, -43699.600802, -22243.337773, 9635.246884, -29812.32798, 9217.191164, -46954.797692, 51794.584171, 49597.670437, -63896.188892, 14544.149564, 61576.085842, -56050.187942, -17524.679812, 20385.617645, 1074.360738, -45926.521783, -61284.027257, -50640.157735};
const float fltY[]      = {-7263.584427, 25051.243451, 19993.885014, 38296.026045, 37686.815518, 20964.482322, 25683.021146, 42077.499103, -40345.389081, -43938.73472, 36384.677955, -39947.166966, 55235.313919, 60362.199058, -29894.377052, 50351.408533, -21511.322321, -59279.237622, -62202.245172, 2705.773305, -28219.405808, -20238.785532, 10795.726159, 37429.923173, -17780.957945, 45817.501512, 1195.131902, 13774.016024, 17333.632576, 47408.021114, 51643.953229, 41620.40388, 11365.243119, 46318.212202, 56089.971849, 4294.009697, -60330.930434, 2382.680296, -35033.426335, 1380.035321, 22444.423625, 4526.093106, 44453.479554, -41587.530727, 15728.023852, 37298.695763, -60319.210868, -17476.403532, -36205.388976, -35946.074991, -21672.513302, 42589.189425, 32679.392836, -27196.698447, -20401.838598, 24876.26202, 43835.727438, -24710.138196, -30804.574723, 1219.990034, -29291.858527, -60773.735535, -13220.205949, 49567.181927, -17027.275368, 39610.206238, -1316.876469, -50116.124259, 58733.625121, 14480.882739, -30078.666768, 26599.961091, -55778.414209, 49865.81361, -6194.465143, 65232.031356, -57339.313906, 12030.564456, 17273.08268, -36838.508874, -38997.639795, 1215.759434, 41608.028552, -28183.494864, -34086.485118, 60514.717131, 2866.532686, -29996.790583, -16337.756398, -3807.802547, -21766.018046, 38339.979119, 7780.582163, 12328.984931, 60109.92648, 21469.776801, -3901.314274, -13414.617809, 7265.774446, 40265.69555};


#if defined (__DEBUG_CONSOLE_PRINT__)
/**
  * @brief  This function is implemented for UART print PinMux configuration.
  * @param  None
  * @retval None
  */
void DebugConsole_PinMux_Config(void)
{
	/* SCI1 UART Tx */
	DDL_GPIO_Config2AltFunc(GPIOA, GPIO_PIN_7, GPIOA7_AF1_SCI1_TX_SDA_MOSI);
}
#endif


/**
  * @brief  This function is implemented for system clock configuration.
  *         where:
  *         System Clock source            = PLL (HIRC)
  *         System Clock frequency         = 100MHz
  * @param  None
  * @retval None
  */
void SystemClock_Config(void)
{
	RCC_PLLInit_T pllInitStruct    = {0};
	RCC_ClkInit_T rccClkInitStruct = {0};

	DDL_RCC_PllStructInit(&pllInitStruct);
	/* FCLK : 100MHz */
	pllInitStruct.pllPrescaler  = 4;
	if (DDL_RCC_PllConfig(&pllInitStruct) != DDL_OK)
	{
		while(1) ;
	}

	/* Select PLL as system clock source */
	rccClkInitStruct.sysClkSource  = RCC_SYSCLKSOURCE_PLLCLK;
	rccClkInitStruct.sysClkDivider = 0;
	if (DDL_RCC_ClkSrcConfig(&rccClkInitStruct) != DDL_OK)
	{
		while(1) ;
	}
}


/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
	/* Reset of all peripherals, Initializes the Flash interface and the Systick. */
	DDL_Init();
	SystemClock_Config();

	/* To make GPIO active */
	DDL_GPIO_Instance_Active();


#if defined (__DEBUG_CONSOLE_PRINT__)
	DebugConsole_PinMux_Config();
	DDL_SCI_Instance_Active(SCI1);
	DDL_SCIUart_DebugConsole_Init(SCI1);
#endif

    printf("It's a tmu demo ... \n");
	/* reset the TMU */
	__DDL_RCC_TMU_ACTIVE();
	__DDL_RCC_TMU_CLK_RELEASE();

	DDL_TMU_Init(TMU);
	float fltCosVal = 0.0f;
	float fltSinVal = 0.0f;

	uint32_t cnt = sizeof(fltAngle)/sizeof(float);
	uint32_t i = 0;

	printf("**************************************Sin & Cosin calculate demo***************************************** \n");
	for (i = 0; i < cnt; i++)
	{
		DDL_TMU_Cosin_Sine_Flt(TMU, fltAngle[i], &fltCosVal, &fltSinVal);
		printf("%d, Angle: %f, sine: %f , cosine: %f \n", i, fltAngle[i], fltSinVal, fltCosVal);
	}

	printf("************************************* Arctan calculate demo ******************************************* \n");

	float fltAngleArctan = 0.0f;
	cnt = sizeof(fltX)/sizeof(float);

	for (i = 0;i < cnt; i++)
	{
		DDL_TMU_ArcTan_Flt(TMU, &fltAngleArctan, fltX[i], fltY[i]);
		printf("%d X: %f, Y: %f , arcTan: %f \n",i, fltX[i], fltY[i], fltAngleArctan);
	}
    while (1)
    {
		;
    }
}

