; Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
; 
; Redistribution and use in source and binary forms, with or without modification, 
; are permitted provided that the following conditions are met:
; 
;   1. Redistributions of source code must retain the above copyright notice, 
;      this list of conditions and the following disclaimer.
; 
;   2. Redistributions in binary form must reproduce the above copyright notice, 
;      this list of conditions and the following disclaimer in the documentation 
;      and/or other materials provided with the distribution.
; 
;   3. Neither the name of the copyright holder nor the names of its contributors 
;      may be used to endorse or promote products derived from this software without 
;      specific prior written permission.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
; OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
; THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
; EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
; AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
; THE POSSIBILITY OF SUCH DAMAGE.
; Amount of memory (in bytes) allocated for Stack
; Tailor this value to your application needs

; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>
        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:NOROOT(2)


        EXTERN  __iar_program_start
        EXTERN  SystemInit
        PUBLIC  __vector_table
        
        PUBLIC  __Vectors
        PUBLIC  __Vectors_End
        PUBLIC  __Vectors_Size

        DATA
__vector_table       
        DCD     sfe(CSTACK)                   
        DCD     Reset_Handler                  		; Reset Handler
        DCD     NMI_Handler                    		; NMI Handler
        DCD     HardFault_Handler              		; Hard Fault Handler
        DCD     MemManage_Handler			   		; Reserved
        DCD     BusFault_Handler			   		; Reserved
        DCD     UsageFault_Handler			   		; Reserved
        DCD     0                              		; Reserved
        DCD     0                              		; Reserved
        DCD     0                              		; Reserved
        DCD     0                              		; Reserved
        DCD     SVC_Handler                    		; SVCall Handler
        DCD     0                              		; Reserved
        DCD     0                              		; Reserved
        DCD     PendSV_Handler                 		; PendSV Handler
        DCD     SysTick_Handler                		; SysTick Handler
      
        ; External Interrupts
        DCD     WWDG_IRQHandler                		; 0
        DCD     LVD_IRQHandler                 		; 1 
        DCD     RESERVED_2_IRQHandler               ; 2
        DCD     FLASH_IRQHandler               		; 3
        DCD     DMA_IRQHandler                 		; 4
        DCD     CAN_IRQHandler        				; 5
        DCD     RESERVED_6_IRQHandler        		; 6
        DCD     SPI_IRQHandler        				; 7
        DCD     RESERVED_8_IRQHandler        		; 8
        DCD     IOW_IRQHandler                 		; 9
        DCD     I2C0_IRQHandler                 	; 10
        DCD     I2C1_IRQHandler        				; 11                
        DCD     SCI0_IRQHandler            			; 12
        DCD     SCI1_IRQHandler            			; 13
        DCD     SCI2_IRQHandler            			; 14
        DCD     RESERVED_15_IRQHandler              ; 15
        DCD     ACMP0_IRQHandler            		; 16
        DCD     ACMP1_IRQHandler            		; 17
        DCD     ACMP2_IRQHandler                	; 18
        DCD     ACMP3_IRQHandler              		; 19
        DCD     ADC0_IRQHandler        				; 20
        DCD     ADC1_IRQHandler           			; 21
        DCD     BaseTimer0_IRQHandler        		; 22
        DCD     BaseTimer1_IRQHandler               ; 23
        DCD     IOPort_INTP0_IRQHandler        		; 24
        DCD     IOPort_INTP1_IRQHandler        		; 25
        DCD     IOPort_INTP2_IRQHandler        		; 26
        DCD     IOPort_INTP3_IRQHandler       		; 27
        DCD     IOPort_INTP4_IRQHandler       		; 28
        DCD     IOPort_INTP5_IRQHandler				; 29
        DCD     IOPort_INTP6_IRQHandler				; 30
        DCD     IOPort_INTP7_IRQHandler				; 31
		DCD     TIMA0_IRQHandler	                ; 32
		DCD     TIMA1_IRQHandler	                ; 33
		DCD     TIMH0_IRQHandler	                ; 34
		DCD     TIMG0_IRQHandler	                ; 35
		DCD     TIMG1_IRQHandler	                ; 36
		DCD     TIMG2_IRQHandler	                ; 37
		DCD     TIMS0_IRQHandler	                ; 38
		DCD     TIMS1_IRQHandler	                ; 39
		DCD     TIMS2_IRQHandler	                ; 40
		DCD     TIMS3_IRQHandler	                ; 41
		DCD     IOPort_INTP8_IRQHandler				; 42
		DCD     IOPort_INTP9_IRQHandler				; 43
		DCD     IOPort_INTP10_IRQHandler			; 44
		DCD     IOPort_INTP11_IRQHandler			; 45
		DCD     IOPort_INTP12_IRQHandler			; 46
		DCD     IOPort_INTP13_IRQHandler			; 47
		DCD     IOPort_INTP14_IRQHandler			; 48
		DCD     IOPort_INTP15_IRQHandler			; 49
		DCD     TIMH1_IRQHandler	                ; 50
		DCD     TIMH2_IRQHandler	                ; 51
		
		
		
		
__Vectors_End

;        SECTION FlashConfig:CODE
;__FlashConfig
;        DCD 0xFFFFFFFF
;        DCD 0xFFFFFFFF
;        DCD 0xFFFFFFFF
;        DCD 0xFFFFFFFF
;__FlashConfig_End

__Vectors       EQU   __vector_table
__Vectors_Size  EQU   __Vectors_End - __Vectors

        THUMB
        PUBWEAK Reset_Handler
        SECTION .text:CODE:REORDER:NOROOT(2)
Reset_Handler


        LDR     R0, =SystemInit
        BLX     R0
        LDR     R0, =__iar_program_start
        BX      R0


; Dummy Exception Handlers (infinite loops which can be modified)

        PUBWEAK NMI_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
        B NMI_Handler
        
        PUBWEAK HardFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
        B HardFault_Handler
        
        PUBWEAK MemManage_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
MemManage_Handler
        B MemManage_Handler
        
        PUBWEAK BusFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
BusFault_Handler
        B BusFault_Handler
        
        PUBWEAK UsageFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
UsageFault_Handler
        B UsageFault_Handler

        PUBWEAK SVC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler  
        B SVC_Handler
        
        PUBWEAK PendSV_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler  
        B PendSV_Handler
        
        PUBWEAK SysTick_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler  
        B SysTick_Handler
        
        PUBWEAK WWDG_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
WWDG_IRQHandler  
        B WWDG_IRQHandler
        
        PUBWEAK LVD_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
LVD_IRQHandler  
        B LVD_IRQHandler
        
        PUBWEAK RESERVED_2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RESERVED_2_IRQHandler  
        B RESERVED_2_IRQHandler
        
        PUBWEAK FLASH_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
FLASH_IRQHandler  
        B FLASH_IRQHandler
        
        PUBWEAK DMA_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA_IRQHandler  
        B DMA_IRQHandler
        
        PUBWEAK CAN_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
CAN_IRQHandler  
        B CAN_IRQHandler
        
        PUBWEAK RESERVED_6_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RESERVED_6_IRQHandler  
        B RESERVED_6_IRQHandler
        
        PUBWEAK SPI_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SPI_IRQHandler  
        B SPI_IRQHandler
        
        PUBWEAK RESERVED_8_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RESERVED_8_IRQHandler  
        B RESERVED_8_IRQHandler
        
        PUBWEAK IOW_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOW_IRQHandler  
        B IOW_IRQHandler
        
        PUBWEAK I2C0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C0_IRQHandler  
        B I2C0_IRQHandler
        
        PUBWEAK I2C1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C1_IRQHandler  
        B I2C1_IRQHandler
        
        PUBWEAK SCI0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SCI0_IRQHandler  
        B SCI0_IRQHandler
        
        PUBWEAK SCI1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SCI1_IRQHandler  
        B SCI1_IRQHandler
        
        PUBWEAK SCI2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SCI2_IRQHandler  
        B SCI2_IRQHandler
        
        PUBWEAK RESERVED_15_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RESERVED_15_IRQHandler  
        B RESERVED_15_IRQHandler
        
        PUBWEAK ACMP0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ACMP0_IRQHandler  
        B ACMP0_IRQHandler
        
        PUBWEAK ACMP1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ACMP1_IRQHandler  
        B ACMP1_IRQHandler
        
        PUBWEAK ACMP2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ACMP2_IRQHandler  
        B ACMP2_IRQHandler
        
        PUBWEAK ACMP3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ACMP3_IRQHandler  
        B ACMP3_IRQHandler
        
        PUBWEAK ADC0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ADC0_IRQHandler  
        B ADC0_IRQHandler
        
        PUBWEAK ADC1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ADC1_IRQHandler  
        B ADC1_IRQHandler
        
        PUBWEAK BaseTimer0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
BaseTimer0_IRQHandler  
        B BaseTimer0_IRQHandler
        
        PUBWEAK BaseTimer1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
BaseTimer1_IRQHandler  
        B BaseTimer1_IRQHandler
        
        PUBWEAK IOPort_INTP0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP0_IRQHandler  
        B IOPort_INTP0_IRQHandler
        
        PUBWEAK IOPort_INTP1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP1_IRQHandler  
        B IOPort_INTP1_IRQHandler
        
        PUBWEAK IOPort_INTP2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP2_IRQHandler  
        B IOPort_INTP2_IRQHandler
        
        PUBWEAK IOPort_INTP3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP3_IRQHandler  
        B IOPort_INTP3_IRQHandler
        
        PUBWEAK IOPort_INTP4_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP4_IRQHandler  
        B IOPort_INTP4_IRQHandler
		
		PUBWEAK IOPort_INTP5_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP5_IRQHandler  
        B IOPort_INTP5_IRQHandler
		
		PUBWEAK IOPort_INTP6_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP6_IRQHandler  
        B IOPort_INTP6_IRQHandler
		
		PUBWEAK IOPort_INTP7_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP7_IRQHandler  
        B IOPort_INTP7_IRQHandler
		
		PUBWEAK TIMA0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMA0_IRQHandler  
        B TIMA0_IRQHandler
		
		PUBWEAK TIMA1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMA1_IRQHandler  
        B TIMA1_IRQHandler
		
		PUBWEAK TIMH0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMH0_IRQHandler  
        B TIMH0_IRQHandler
		
		PUBWEAK TIMG0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMG0_IRQHandler  
        B TIMG0_IRQHandler
		
		PUBWEAK TIMG1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMG1_IRQHandler  
        B TIMG1_IRQHandler
		
		PUBWEAK TIMG2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMG2_IRQHandler  
        B TIMG2_IRQHandler
		
		PUBWEAK TIMS0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMS0_IRQHandler  
        B TIMS0_IRQHandler
		
		PUBWEAK TIMS1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMS1_IRQHandler  
        B TIMS1_IRQHandler
		
		PUBWEAK TIMS2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMS2_IRQHandler  
        B TIMS2_IRQHandler
		
		PUBWEAK TIMS3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMS3_IRQHandler  
        B TIMS3_IRQHandler
		
		PUBWEAK IOPort_INTP8_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP8_IRQHandler  
        B IOPort_INTP8_IRQHandler
		
		PUBWEAK IOPort_INTP9_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP9_IRQHandler  
        B IOPort_INTP9_IRQHandler
		
		PUBWEAK IOPort_INTP10_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP10_IRQHandler  
        B IOPort_INTP10_IRQHandler
		
		PUBWEAK IOPort_INTP11_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP11_IRQHandler  
        B IOPort_INTP11_IRQHandler
		
		PUBWEAK IOPort_INTP12_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP12_IRQHandler  
        B IOPort_INTP12_IRQHandler
		
		PUBWEAK IOPort_INTP13_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP13_IRQHandler  
        B IOPort_INTP13_IRQHandler
		
		PUBWEAK IOPort_INTP14_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP14_IRQHandler  
        B IOPort_INTP14_IRQHandler
		
		PUBWEAK IOPort_INTP15_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
IOPort_INTP15_IRQHandler  
        B IOPort_INTP15_IRQHandler
		
		PUBWEAK TIMH1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMH1_IRQHandler  
        B TIMH1_IRQHandler
		
		PUBWEAK TIMH2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIMH2_IRQHandler  
        B TIMH2_IRQHandler
        
        
        
        END

