#ifndef __SIMULATOR_UART_APP_APP_H
#define __SIMULATOR_UART_APP_APP_H

#ifdef __cplusplus
 extern "C" {
#endif


#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include "kpm32xx_ddl.h"
#include "kpm32xx_it.h"
#include "debug_console_ddl.h"


/* uart app Configuration Structure definition */
typedef struct
{
	uint8_t mlsb;   /* 0:LSB ;  1: MSB */
	uint8_t parity; /* 0:none;  1: ODD; 2: EVEN */
	uint16_t txBaud;
	uint16_t rxBaud;
} SIMU_UART_CONFIG_T;


#define UART_PARITY_NONE   0x00
#define UART_PARITY_ODD    0x01
#define UART_PARITY_EVEN   0x02

#define UART_RECE_OK       		   0x00
#define UART_RECE_PARITY_ERR       0x01
#define UART_RECE_TIMEOUT          0x02

void uart_init(void);
void uart_data_send(uint8_t *pData,uint16_t dataLen);
void simulator_uart_tx(SIMU_UART_CONFIG_T *uartConfig, uint8_t txData);
uint8_t simulator_uart_rx(void);
uint8_t uart_data_receive(uint8_t *pData, uint16_t dataLen);

#ifdef __cplusplus
}
#endif

#endif /* __SIMULATOR_UART_APP_APP_H */
