/**
  ******************************************************************************
  * @file    kpm32xx_ddl_sci_common.c
  * @author  Kiwi Software Team
  * @brief   SCI DDL module driver.
  *          This file provides firmware functions to manage the following
  *          functionalities of SCI module:
  *          + Get SCI channel index
  *          + Get SCI common instance
  *
  * @note
  *          V1.0.0, 2024/12/20.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  ******************************************************************************
  */
#include "kpm32xx_ddl.h"


#if  defined(DDL_SCIUART_MODULE_ENABLED) || defined(DDL_SCII2C_MODULE_ENABLED) || defined(DDL_SCISPI_MODULE_ENABLED)

/**
  * @brief  get SCI instance IRQn.
  * @param  sciInstance  SCI instance.
  *
  * @retval SCI instance IRQn.
  */
IRQn_Type DDL_Get_SCIModule_IRQn(SCI_Type *SCIx)
{
	IRQn_Type irqType = IP_UNDEFINED;

	irqType =  (SCIx == SCI0) ? SCI0_IRQn :
	           (SCIx == SCI1) ? SCI1_IRQn :
			   (SCIx == SCI2) ? SCI2_IRQn : IP_UNDEFINED;

	return irqType;
}


/**
  * @brief  make SCI active.
  * @param  SCIx  SCI instance.
  *
  */
void DDL_SCI_Instance_Active(SCI_Type *SCIx)
{
	if (SCIx == SCI0)
	{
		__DDL_RCC_SCI0_ACTIVE();
		__DDL_RCC_SCI0_CLK_RELEASE();
	}

	if (SCIx == SCI1)
	{
		__DDL_RCC_SCI1_ACTIVE();
		__DDL_RCC_SCI1_CLK_RELEASE();
	}

	if (SCIx == SCI2)
	{
		__DDL_RCC_SCI2_ACTIVE();
		__DDL_RCC_SCI2_CLK_RELEASE();
	}
}

#endif /* DDL_SCIUART_MODULE_ENABLED, DDL_SCII2C_MODULE_ENABLED, DDL_SCISPI_MODULE_ENABLED */

