/**
  ******************************************************************************
  * @file    kpm32xx_ddl_conf.h
  * @author  Kiwi Software Team
  * @brief   DDL configuration header file.
  *          Users are free to mask the module macros which are not referred to
  *          in application code.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  ******************************************************************************
  */


#ifndef KPM32xx_DDL_CONF_H
#define KPM32xx_DDL_CONF_H

#ifdef __cplusplus
extern "C" {
#endif


/**
  * List all the modules in the DDL driver
  */
#define DDL_MODULE_ENABLED
/* #define DDL_ADC_MODULE_ENABLED       */
/* #define DDL_CRC_MODULE_ENABLED       */
/* #define DDL_I2C_MODULE_ENABLED       */
/* #define DDL_TIMA_MODULE_ENABLED      */
/* #define DDL_TIMG_MODULE_ENABLED      */
#define DDL_TIMS_MODULE_ENABLED
/* #define DDL_TIMH_MODULE_ENABLED      */
/* #define DDL_WWDG_MODULE_ENABLED      */
#define DDL_GPIO_MODULE_ENABLED
/* #define DDL_DMA_MODULE_ENABLED       */
#define DDL_RCC_MODULE_ENABLED
#define DDL_FLASH_MODULE_ENABLED
/* #define DDL_PWR_MODULE_ENABLED       */
/* #define DDL_EBUS_MODULE_ENABLED      */
/* #define DDL_TMU_MODULE_ENABLED       */
#define DDL_SCIUART_MODULE_ENABLED
/* #define DDL_SCII2C_MODULE_ENABLED    */
/* #define DDL_SCISPI_MODULE_ENABLED    */
/* #define DDL_SPI_MODULE_ENABLED       */
/* #define DDL_BASETIMER_MODULE_ENABLED */
/* #define DDL_IOPORT_MODULE_ENABLED    */
/* #define DDL_IOW_MODULE_ENABLED     	*/
/* #define DDL_CAN_MODULE_ENABLED       */
/* #define DDL_LVD_MODULE_ENABLED       */
/* #define DDL_CMP_MODULE_ENABLED      */

/**
  * SystemTick interrupt priority
  */
#define  TICK_INT_PRIORITY            ((1UL<<__NVIC_PRIO_BITS) - 1UL) /*!< tick interrupt priority */

/**
  * Use OS or not
  */
#define  USE_RTOS                     0U

/**
  * Uncomment to use "ASSERT_PARAM" macro.
  */
/* #define USE_ASSERT    1U */

/**
  * Include module's header file
  */
#ifdef DDL_RCC_MODULE_ENABLED
#include "kpm32xx_ddl_rcc.h"
#endif /* DDL_RCC_MODULE_ENABLED */

#ifdef DDL_GPIO_MODULE_ENABLED
#include "kpm32xx_ddl_gpio.h"
#endif /* DDL_GPIO_MODULE_ENABLED */

#ifdef DDL_DMA_MODULE_ENABLED
#include "kpm32xx_ddl_dma.h"
#endif /* DDL_DMA_MODULE_ENABLED */

#ifdef DDL_ADC_MODULE_ENABLED
#include "kpm32xx_ddl_adc.h"
#endif /* DDL_ADC_MODULE_ENABLED */

#ifdef DDL_CRC_MODULE_ENABLED
#include "kpm32xx_ddl_crc.h"
#endif /* DDL_CRC_MODULE_ENABLED */

#ifdef DDL_FLASH_MODULE_ENABLED
#include "kpm32xx_ddl_flash.h"
#endif /* DDL_FLASH_MODULE_ENABLED */

#ifdef DDL_I2C_MODULE_ENABLED
#include "kpm32xx_ddl_i2c.h"
#endif /* DDL_I2C_MODULE_ENABLED */

#ifdef DDL_PWR_MODULE_ENABLED
#include "kpm32xx_ddl_pwr.h"
#endif /* DDL_PWR_MODULE_ENABLED */

#ifdef DDL_TIMA_MODULE_ENABLED
#include "kpm32xx_ddl_tima.h"
#endif /* DDL_TIMA_MODULE_ENABLED */

#ifdef DDL_TIMG_MODULE_ENABLED
#include "kpm32xx_ddl_timg.h"
#endif /* DDL_TIMG_MODULE_ENABLED */

#ifdef DDL_TIMS_MODULE_ENABLED
#include "kpm32xx_ddl_tims.h"
#endif /* DDL_TIMS_MODULE_ENABLED */

#ifdef DDL_TIMH_MODULE_ENABLED
#include "kpm32xx_ddl_timh.h"
#endif /* DDL_TIMH_MODULE_ENABLED */

#ifdef DDL_WWDG_MODULE_ENABLED
#include "kpm32xx_ddl_wwdg.h"
#endif /* DDL_WWDG_MODULE_ENABLED */

#ifdef DDL_EBUS_MODULE_ENABLED
#include "kpm32xx_ddl_ebus.h"
#endif /* DDL_EBUS_MODULE_ENABLED */

#ifdef DDL_TMU_MODULE_ENABLED
#include "kpm32xx_ddl_tmu.h"
#endif /* DDL_TMU_MODULE_ENABLED */

#ifdef DDL_SPI_MODULE_ENABLED
#include "kpm32xx_ddl_spi.h"
#endif /* DDL_SPI_MODULE_ENABLED */

#ifdef DDL_SCIUART_MODULE_ENABLED
#include "kpm32xx_ddl_sci_uart.h"
#endif /* DDL_SCIUART_MODULE_ENABLED */

#ifdef DDL_SCISPI_MODULE_ENABLED
#include "kpm32xx_ddl_sci_spi.h"
#endif /* DDL_SCISPI_MODULE_ENABLED */

#ifdef DDL_SCII2C_MODULE_ENABLED
#include "kpm32xx_ddl_sci_i2c.h"
#endif /* DDL_SCII2C_MODULE_ENABLED */

#ifdef DDL_BASETIMER_MODULE_ENABLED
#include "kpm32xx_ddl_basetimer.h"
#endif /* DDL_BASETIMER_MODULE_ENABLED */

#ifdef DDL_IOW_MODULE_ENABLED
#include "kpm32xx_ddl_iow.h"
#endif /* DDL_IOW_MODULE_ENABLED */

#ifdef DDL_IOPORT_MODULE_ENABLED
#include "kpm32xx_ddl_ioport.h"
#endif /* DDL_IOPORT_MODULE_ENABLED */

#ifdef DDL_CAN_MODULE_ENABLED
#include "kpm32xx_ddl_can.h"
#endif /* DDL_CAN_MODULE_ENABLED */

#ifdef DDL_LVD_MODULE_ENABLED
#include "kpm32xx_ddl_lvd.h"
#endif /* DDL_LVD_MODULE_ENABLED */

#ifdef DDL_CMP_MODULE_ENABLED
#include "kpm32xx_ddl_cmp.h"
#endif /* DDL_CMP_MODULE_ENABLED */


#ifdef  USE_ASSERT
/**
  * The ASSERT_PARAM macro is used for function parameters check.
  */
#define ASSERT_PARAM(expr) ((expr) ? (void)0U : Assert_Failed((uint8_t *)__FILE__, __LINE__))

void Assert_Failed(uint8_t *file, uint32_t line);
#else
#define ASSERT_PARAM(expr) ((void)0U)
#endif /* USE_ASSERT */

#ifdef __cplusplus
}
#endif

#endif /* KPM32xx_DDL_CONF_H */

