/**
  *****************************************************************************************************
  * @file    main.c
  * @author  Kiwi Software Team
  * @brief   This example code demonstrates how SCI SPI works.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */

#include "main.h"
#include "kpm32xx_demoboard_ddl.h"



#define __MAXIMUM_RD_LENGTH__       8

uint8_t wrBuf[__MAXIMUM_RD_LENGTH__] = {0x98, 0xFF, 0x36, 0x89, 0x3E, 0x75, 0x88, 0x67};
uint8_t rdBuf[__MAXIMUM_RD_LENGTH__] = {0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A, 0x5A};


/**
  * @brief  This function is implemented for SPI PinMux configuration.
  * @param  None
  * @retval None
  */
void SPI_PinMux_Config(void)
{
    /* Initialize Serial Unit CS pin */
    DDL_GPIO_Config2AltFunc(GPIOA, GPIO_PIN_0, GPIOA0_AF0_SCI0_RTS_CS_CTS);
    /* Initialize Sci MISO pin */
    DDL_GPIO_Config2AltFunc(GPIOA, GPIO_PIN_11, GPIOA11_AF0_SCI0_RX_MISO);
    /* Initialize Sci SCk pin */
    DDL_GPIO_Config2AltFunc(GPIOA, GPIO_PIN_12, GPIOA12_AF0_SCI0_SCK_CTS);
    /* Initialize Sci MOSI pin */
    DDL_GPIO_Config2AltFunc(GPIOA, GPIO_PIN_10, GPIOA10_AF3_SCI0_TX_SDA_MOSI);
}


/**
  * @brief  This function is implemented for system clock configuration.
  *         where:
  *         System Clock source            = PLL (HIRC)
  *         System Clock frequency         = 100MHz
  * @param  None
  * @retval None
  */
void SystemClock_Config(void)
{
	RCC_PLLInit_T pllInitStruct    = {0};
	RCC_ClkInit_T rccClkInitStruct = {0};

	DDL_RCC_PllStructInit(&pllInitStruct);
	/* FCLK : 100MHz */
	pllInitStruct.pllPrescaler  = 4;
	if (DDL_RCC_PllConfig(&pllInitStruct) != DDL_OK)
	{
		while(1) ;
	}

	/* Select PLL as system clock source */
	rccClkInitStruct.sysClkSource  = RCC_SYSCLKSOURCE_PLLCLK;
	rccClkInitStruct.sysClkDivider = 0;
	if (DDL_RCC_ClkSrcConfig(&rccClkInitStruct) != DDL_OK)
	{
		while(1) ;
	}
}




/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
	SCISPI_Init_T pSCISPIStruct;
    /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
    DDL_Init();
    SystemClock_Config();
	DDL_Delay(3000);
    SPI_PinMux_Config();
    DDL_SCI_Instance_Active(SCI0);

    DDL_SCISPI_StructInit(&pSCISPIStruct);
    pSCISPIStruct.workMode  = SCISPI_MASTER;
	pSCISPIStruct.mlsb      = SCIUART_MSB_FIRST;
    /* 400000 baud*/
	pSCISPIStruct.clkPres     = 3;
	pSCISPIStruct.brDiv1And2  = 0x3B << 16;
    DDL_SCISPI_Init(SCI0, &pSCISPIStruct);

	while(1)
	{
        DDL_SCISPI_Transmit(SCI0, wrBuf, sizeof(wrBuf)/sizeof(uint8_t), 10000);
        DDL_Delay(500);
        DDL_SCISPI_Receive(SCI0, rdBuf, sizeof(rdBuf)/sizeof(uint8_t), 10000);
        DDL_Delay(500);
	}
}






