/**
  *****************************************************************************************************
  * @file    kpm32xx_demoboard_ddl.c
  * @author  Kiwi Software Team
  * @brief   Demo board BSP code here.
  * @note
  *          V1.0.0, 2024/12/20.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification, 
  * are permitted provided that the following conditions are met:
  * 
  *   1. Redistributions of source code must retain the above copyright notice, 
  *      this list of conditions and the following disclaimer.
  * 
  *   2. Redistributions in binary form must reproduce the above copyright notice, 
  *      this list of conditions and the following disclaimer in the documentation 
  *      and/or other materials provided with the distribution.
  * 
  *   3. Neither the name of the copyright holder nor the names of its contributors 
  *      may be used to endorse or promote products derived from this software without 
  *      specific prior written permission.
  * 
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */


#include "kpm32xx_demoboard_ddl.h"

static GPIO_Type *LedPort[3] = {GPIOA, GPIOA, GPIOD};
static uint32_t LedPin[3] = {GPIO_PIN_0, GPIO_PIN_1, GPIO_PIN_12};

static GPIO_Type *BtnPort[1] = {GPIOA};
static uint32_t BtnPin[1] = {GPIO_PIN_2};

/**
  * @brief  BSP led initialize.
  * @param  ledIndex  led index.
  *
  * @retval None
  */
void BSP_LEDx_Init(LEDx_Index_T ledIndex)
{
   /* Make Ledx off initially */	
	DDL_GPIO_Config2Output(LedPort[ledIndex], LedPin[ledIndex], 1, GPIO_NOPULL);
}


/**
  * @brief  Led twinkles.
  * @param  ledIndex  led index.
  *
  * @retval None
  */
void BSP_LEDx_Twinkle(LEDx_Index_T ledIndex)
{
	DDL_GPIO_TogglePin(LedPort[ledIndex], LedPin[ledIndex]);
}


/**
  * @brief  Led turns on.
  * @param  ledIndex  led index.
  *
  * @retval None
  */
void BSP_LEDx_On(LEDx_Index_T ledIndex)
{
	DDL_GPIO_WritePin(LedPort[ledIndex], LedPin[ledIndex], GPIO_PIN_RESET);
}

/**
  * @brief  Led turns off.
  * @param  ledIndex  led index.
  *
  * @retval None
  */
void BSP_LEDx_Off(LEDx_Index_T ledIndex)
{
	DDL_GPIO_WritePin(LedPort[ledIndex], LedPin[ledIndex], GPIO_PIN_SET);
}


/**
  * @brief  Get button state (pressed or not).
  * @param  btnIndex  button index.
  *
  * @retval Button state.
  */
BTNx_State_T BSP_BTNx_State(BTNx_Index_T btnIndex)
{
	return DDL_GPIO_ReadPin(BtnPort[btnIndex], BtnPin[btnIndex]) == GPIO_PIN_SET ? UNPRESSED : PRESSED;
}

