; Amount of memory (in bytes) allocated for Stack
; Tailor this value to your application needs

; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>
Stack_Size      EQU     0x00001000

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>
Heap_Size       EQU     0x00000200

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit

                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp                   ; Top of Stack
                DCD     Reset_Handler                  ; Reset Handler
                DCD     NMI_Handler                    ; NMI Handler
                DCD     HardFault_Handler              ; Hard Fault Handler
                DCD     MemManage_Handler              ; MPU Fault Handler
                DCD     BusFault_Handler               ; Bus Fault Handler
                DCD     UsageFault_Handler             ; Usage Fault Handler
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     SVC_Handler                    ; SVCall Handler
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     PendSV_Handler                 ; PendSV Handler
                DCD     SysTick_Handler                ; SysTick Handler

                ; External Interrupts
                DCD     WWDG_IRQHandler                ; 0
                DCD     LVD_IRQHandler                 ; 1
                DCD     RESERVED_2_IRQHandler          ; 2
                DCD     FLASH_IRQHandler               ; 3
                DCD     DMA_IRQHandler                 ; 4
                DCD     CAN_IRQHandler                 ; 5
                DCD     RESERVED_6_IRQHandler          ; 6
                DCD     SPI_IRQHandler                 ; 7
                DCD     RESERVED_8_IRQHandler          ; 8
                DCD     IOW_IRQHandler                 ; 9
                DCD     I2C0_IRQHandler                ; 10
                DCD     I2C1_IRQHandler                ; 11
                DCD     SCI0_IRQHandler                ; 12
                DCD     SCI1_IRQHandler                ; 13
                DCD     SCI2_IRQHandler                ; 14
                DCD     RESERVED_15_IRQHandler         ; 15
                DCD     ACMP0_IRQHandler               ; 16
                DCD     ACMP1_IRQHandler               ; 17
                DCD     ACMP2_IRQHandler               ; 18
                DCD     ACMP3_IRQHandler               ; 19
                DCD     ADC0_IRQHandler                ; 20
				DCD     ADC1_IRQHandler                ; 21
                DCD     BaseTimer0_IRQHandler          ; 22
                DCD     BaseTimer1_IRQHandler          ; 23
                DCD     IOPort_INTP0_IRQHandler        ; 24
                DCD     IOPort_INTP1_IRQHandler        ; 25
                DCD     IOPort_INTP2_IRQHandler        ; 26
                DCD     IOPort_INTP3_IRQHandler        ; 27
                DCD     IOPort_INTP4_IRQHandler        ; 28
				DCD     IOPort_INTP5_IRQHandler        ; 29
				DCD     IOPort_INTP6_IRQHandler        ; 30
				DCD     IOPort_INTP7_IRQHandler        ; 31
                DCD     TIMA0_IRQHandler               ; 32
                DCD     TIMA1_IRQHandler               ; 33
		        DCD     TIMH0_IRQHandler               ; 34
				DCD     TIMG0_IRQHandler               ; 35
                DCD     TIMG1_IRQHandler               ; 36
		        DCD     TIMG2_IRQHandler	           ; 37
				DCD     TIMS0_IRQHandler               ; 38
                DCD     TIMS1_IRQHandler               ; 39
		        DCD     TIMS2_IRQHandler	           ; 40
				DCD     TIMS3_IRQHandler	           ; 41
                DCD     IOPort_INTP8_IRQHandler        ; 42
                DCD     IOPort_INTP9_IRQHandler        ; 43
                DCD     IOPort_INTP10_IRQHandler       ; 44
                DCD     IOPort_INTP11_IRQHandler       ; 45
                DCD     IOPort_INTP12_IRQHandler       ; 46
				DCD     IOPort_INTP13_IRQHandler       ; 47
				DCD     IOPort_INTP14_IRQHandler       ; 48
				DCD     IOPort_INTP15_IRQHandler       ; 49
		        DCD     TIMH1_IRQHandler               ; 50
		        DCD     TIMH2_IRQHandler               ; 51

__Vectors_End

__Vectors_Size  EQU  __Vectors_End - __Vectors



                AREA    |.text|, CODE, READONLY

				IF      :LNOT::DEF:RAM_TARGET
                AREA    |.ARM.__at_0x08000400|, CODE, READONLY
				DCD     0xFFFFFFFF                    ; Page Protect Mode
				DCD     0xFFFFFFFF                    ; Security Mode
				DCD     0xFFFFFFFF                    ; Watchdog setting
				DCD     0xFFFFFFFF                    ; SWD key
				ENDIF

; Reset handler routine
Reset_Handler    PROC
                 EXPORT  Reset_Handler                 [WEAK]
        IMPORT  __main
        IMPORT  SystemInit  
                 LDR     R0, =SystemInit
                 BLX     R0
                 LDR     R0, =__main
                 BX      R0
                 ENDP

; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler                    [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler              [WEAK]
                B       .
                ENDP
MemManage_Handler\
                PROC
                EXPORT  MemManage_Handler              [WEAK]
                B       .
                ENDP
BusFault_Handler\
                PROC
                EXPORT  BusFault_Handler               [WEAK]
                B       .
                ENDP
UsageFault_Handler\
                PROC
                EXPORT  UsageFault_Handler             [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler                    [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler                 [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler                [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  WWDG_IRQHandler                [WEAK]     ;0
                EXPORT  LVD_IRQHandler                 [WEAK]     ;1
                EXPORT  RESERVED_2_IRQHandler          [WEAK]     ;2
                EXPORT  FLASH_IRQHandler               [WEAK]     ;3
                EXPORT  DMA_IRQHandler                 [WEAK]     ;4
                EXPORT  CAN_IRQHandler                 [WEAK]     ;5
                EXPORT  RESERVED_6_IRQHandler          [WEAK]     ;6
                EXPORT  SPI_IRQHandler                 [WEAK]     ;7
                EXPORT  RESERVED_8_IRQHandler          [WEAK]     ;8
                EXPORT  IOW_IRQHandler                 [WEAK]     ;9
                EXPORT  I2C0_IRQHandler                [WEAK]     ;10
                EXPORT  I2C1_IRQHandler                [WEAK]     ;11
                EXPORT  SCI0_IRQHandler                [WEAK]     ;12
                EXPORT  SCI1_IRQHandler                [WEAK]     ;13
                EXPORT  SCI2_IRQHandler                [WEAK]     ;14
                EXPORT  RESERVED_15_IRQHandler         [WEAK]     ;15
                EXPORT  ACMP0_IRQHandler               [WEAK]     ;16
                EXPORT  ACMP1_IRQHandler               [WEAK]     ;17
                EXPORT  ACMP2_IRQHandler               [WEAK]     ;18
                EXPORT  ACMP3_IRQHandler               [WEAK]     ;19
                EXPORT  ADC0_IRQHandler                [WEAK]     ;20
                EXPORT  ADC1_IRQHandler                [WEAK]     ;21
                EXPORT  BaseTimer0_IRQHandler          [WEAK]     ;22
                EXPORT  BaseTimer1_IRQHandler          [WEAK]     ;23
                EXPORT  IOPort_INTP0_IRQHandler        [WEAK]     ;24
                EXPORT  IOPort_INTP1_IRQHandler        [WEAK]     ;25
                EXPORT  IOPort_INTP2_IRQHandler        [WEAK]     ;26
                EXPORT  IOPort_INTP3_IRQHandler        [WEAK]     ;27
                EXPORT  IOPort_INTP4_IRQHandler        [WEAK]     ;28
                EXPORT  IOPort_INTP5_IRQHandler        [WEAK]     ;29
                EXPORT  IOPort_INTP6_IRQHandler        [WEAK]	  ;30
                EXPORT  IOPort_INTP7_IRQHandler        [WEAK]	  ;31
                EXPORT  TIMA0_IRQHandler               [WEAK]     ;32
                EXPORT  TIMA1_IRQHandler               [WEAK]     ;33
                EXPORT  TIMH0_IRQHandler               [WEAK]     ;34
                EXPORT  TIMG0_IRQHandler               [WEAK]     ;35
                EXPORT  TIMG1_IRQHandler               [WEAK]     ;36
                EXPORT  TIMG2_IRQHandler               [WEAK]     ;37
                EXPORT  TIMS0_IRQHandler               [WEAK]     ;38
                EXPORT  TIMS1_IRQHandler               [WEAK]     ;39
                EXPORT  TIMS2_IRQHandler               [WEAK]     ;40
                EXPORT  TIMS3_IRQHandler               [WEAK]     ;41
                EXPORT  IOPort_INTP8_IRQHandler        [WEAK]     ;42
                EXPORT  IOPort_INTP9_IRQHandler        [WEAK]     ;43
                EXPORT  IOPort_INTP10_IRQHandler       [WEAK]     ;44
                EXPORT  IOPort_INTP11_IRQHandler       [WEAK]     ;45
                EXPORT  IOPort_INTP12_IRQHandler       [WEAK]	  ;46
                EXPORT  IOPort_INTP13_IRQHandler       [WEAK]	  ;47
                EXPORT  IOPort_INTP14_IRQHandler       [WEAK]	  ;48
                EXPORT  IOPort_INTP15_IRQHandler       [WEAK]	  ;49
                EXPORT  TIMH1_IRQHandler               [WEAK]     ;50
                EXPORT  TIMH2_IRQHandler               [WEAK]     ;51



WWDG_IRQHandler
LVD_IRQHandler
RESERVED_2_IRQHandler
FLASH_IRQHandler
DMA_IRQHandler
CAN_IRQHandler
RESERVED_6_IRQHandler
SPI_IRQHandler
RESERVED_8_IRQHandler
IOW_IRQHandler
I2C0_IRQHandler
I2C1_IRQHandler
SCI0_IRQHandler
SCI1_IRQHandler
SCI2_IRQHandler
RESERVED_15_IRQHandler
ACMP0_IRQHandler
ACMP1_IRQHandler
ACMP2_IRQHandler
ACMP3_IRQHandler
ADC0_IRQHandler
ADC1_IRQHandler
BaseTimer0_IRQHandler
BaseTimer1_IRQHandler
IOPort_INTP0_IRQHandler
IOPort_INTP1_IRQHandler
IOPort_INTP2_IRQHandler
IOPort_INTP3_IRQHandler
IOPort_INTP4_IRQHandler
IOPort_INTP5_IRQHandler
IOPort_INTP6_IRQHandler
IOPort_INTP7_IRQHandler
TIMA0_IRQHandler
TIMA1_IRQHandler
TIMH0_IRQHandler
TIMG0_IRQHandler
TIMG1_IRQHandler
TIMG2_IRQHandler
TIMS0_IRQHandler
TIMS1_IRQHandler
TIMS2_IRQHandler
TIMS3_IRQHandler
IOPort_INTP8_IRQHandler
IOPort_INTP9_IRQHandler
IOPort_INTP10_IRQHandler
IOPort_INTP11_IRQHandler
IOPort_INTP12_IRQHandler
IOPort_INTP13_IRQHandler
IOPort_INTP14_IRQHandler
IOPort_INTP15_IRQHandler
TIMH1_IRQHandler
TIMH2_IRQHandler

                B       .

                ENDP

                ALIGN

;*******************************************************************************
; User Stack and Heap initialization
;*******************************************************************************
                 IF      :DEF:__MICROLIB

                 EXPORT  __initial_sp
                 EXPORT  __heap_base
                 EXPORT  __heap_limit

                 ELSE

                 IMPORT  __use_two_region_memory
                 EXPORT  __user_initial_stackheap

__user_initial_stackheap

                 LDR     R0, =  Heap_Mem
                 LDR     R1, =(Stack_Mem + Stack_Size)
                 LDR     R2, = (Heap_Mem +  Heap_Size)
                 LDR     R3, = Stack_Mem
                 BX      LR

                 ALIGN

                 ENDIF

                 END

