/**
  *****************************************************************************************************
  * @file    uart_user_drv.h
  * @author  Kiwi Software Team
  * @brief   Header file of uart_user_drv.c module.
  * @note
  *          V1.0.0, 2024/12/20.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */



#ifndef __UART_USER_DRV_H
#define __UART_USER_DRV_H

#ifdef __cplusplus
extern "C" {
#endif

#include "kpm32xx_demoboard_ddl.h"
#include <stdio.h>


typedef enum
{
	UART_TX        = 0x00U,
	UART_RX        = 0x01U,
} UartTxRx_T;


/**
  * @brief  receives an amount of data with interrupt.
  * @param  SCIx Pointer to SCI UART instance.
  *
  * @retval None
  */
void DDL_SCIUART_User_Receive_IT(SCI_Type *SCIx);


/**
  * @brief  transmits an amount of data with interrupt.
  * @param  SCIx Pointer to SCI UART instance.
  * @param  pData    pointer to data buffer (uint8_t or uint16_t data frame).
  * @param  size     the amount of data frame (uint8_t or uint16_t) to be sent.
  *
  * @retval None
  */
void DDL_SCIUART_User_Transmit_IT(SCI_Type *SCIx, uint8_t *pData, uint16_t size);


/**
  * @brief  Mutually configure UART Tx and Rx .
  * @param  SCIx Pointer to SCI UART instance.
  * @param  uartTxRx UART Tx and Rx configuration.
  *
  * @retval None
  */
void Uart_TransData_RxTx_Mutual(SCI_Type *SCIx, UartTxRx_T uartTxRx);

#ifdef __cplusplus
}
#endif

#endif /* __UART_USER_DRV_H */
