/**
  *****************************************************************************************************
  * @file    kpm32xx_it.c
  * @author  Kiwi Software Team
  * @brief   This file provides routines for all CPU exceptions handler and
  *          external peripherals interrupt service.
  *
  * Copyright (c) 2024, Kiwi Instruments Co,. Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */

#include "main.h"


/**
  * @brief This function handles Non-Maskable interrupt.
  */
void NMI_Handler(void)
{

}


/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
	while (1)
	{

	}
}


/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{

}


/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{

}


/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
    DDL_IncTick();
}


/**
  * @brief This function handles CAN interrupt.
  */
#ifdef DDL_CAN_MODULE_ENABLED
extern uint32_t can_event;

void CAN_IRQHandler(void)
{
	if (CAN->INTST & CAN_INTST_DATAOVERFLOW)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_DATAOVERFLOW);
		can_event |= CAN_INTST_DATAOVERFLOW;
	}

	if (CAN->INTST & CAN_INTST_RECEIVE)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_RECEIVE);
		can_event |= CAN_INTST_RECEIVE;
	}

	if (CAN->INTST & CAN_INTST_TRANSMIT)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_TRANSMIT);
		can_event |= CAN_INTST_TRANSMIT;
	}

	if (CAN->INTST & CAN_INTST_ARBITLOST)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_ARBITLOST);
		can_event |= CAN_INTST_ARBITLOST;
	}

	if (CAN->INTST & CAN_INTST_BUSERR)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_BUSERR);
		can_event |= CAN_INTST_BUSERR;
	}

	if (CAN->INTST & CAN_INTST_ERRPASSIVE)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_ERRPASSIVE);
		can_event |= CAN_INTST_ERRPASSIVE;
	}

	if (CAN->INTST & CAN_INTST_ERRWARNING)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_ERRWARNING);
		can_event |= CAN_INTST_ERRWARNING;
	}

	if (CAN->INTST & CAN_INTST_WAKEUP)
	{
		WRITE_REG(CAN->INTST, CAN_INTST_WAKEUP);
		can_event |= CAN_INTST_WAKEUP;
	}
}

#endif

