/**
  *****************************************************************************************************
  * @file    main.c
  * @author  AdvanChip Software Team
  * @brief   This example code demonstrates how basetimer(16bit mode) works.
  *
  * Copyright (c) 2021, Advanchip Semiconductor Ltd.
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *
  *   3. Neither the name of the copyright holder nor the names of its contributors
  *      may be used to endorse or promote products derived from this software without
  *      specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
  * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
  * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  * THE POSSIBILITY OF SUCH DAMAGE.
  *****************************************************************************************************
  */

#include "main.h"

#include "simulator_uart_driver.h"
#include "simulator_uart_app.h"

void SystemClock_Config(void);
uint8_t uartSend[10] = {0xAA,0x55,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88};
uint8_t uartRece[10] = {0};

	
/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
	/* Reset of all peripherals. */
	DDL_Init();
//	DDL_Delay(1000);
	SystemClock_Config();

	/* To make GPIO active */
	DDL_GPIO_Instance_Active();
	DDL_GPIO_Config2Output(UART_PORT_TX, UART_PIN_TX, 1, 0);/* tx */
	DDL_GPIO_Config2Input(UART_PORT_RX, UART_PIN_RX, 0);    /* rx */
	
	DDL_GPIO_Config2Output(GPIOC, GPIO_PIN_14, 1, 0);/* ebus test */
	DDL_GPIO_Config2Output(GPIOD, GPIO_PIN_4, 1, 0);/* tims ccr int test */
	
	ebus_init();
	dma_init();
	
	ioport_init();
	uart_init();
	tims_pwm_init();
	BTM00_16bit_Init();
	
    while(1)
    {	 
		 if (uart_data_receive(uartRece, 10) == 0)
		 {
			uart_data_send(uartRece,10);;
		 }
//		uart_data_send(uartSend,10);;
//		DDL_Delay(50);
    }
}

	
/**
  * @brief  This function is implemented for system clock configuration.
  *         where:
  *         System Clock source            = PLL (HIRC)
  *         System Clock frequency         = 200MHz
  * @param  None
  * @retval None
  */
void SystemClock_Config(void)
{
	RCC_PLLInit_T pllInitStruct    = {0};
	RCC_ClkInit_T rccClkInitStruct = {0};

	DDL_RCC_PllStructInit(&pllInitStruct);
	/* FCLK : 100MHz */
	pllInitStruct.pllPrescaler  = 4;
	if (DDL_RCC_PllConfig(&pllInitStruct) != DDL_OK)
	{
		while(1) ;
	}

	/* Select PLL as system clock source */
	rccClkInitStruct.sysClkSource  = RCC_SYSCLKSOURCE_PLLCLK;
	rccClkInitStruct.sysClkDivider = 0;
	if (DDL_RCC_ClkSrcConfig(&rccClkInitStruct) != DDL_OK)
	{
		while(1) ;
	}
}



